#ifndef GUIAGENT_H_
#define GUIAGENT_H_

#include "IAgent.h"
#include "IFilter.h"
#include "FilterFactory.h"
using namespace std;
namespace Communication
{

class GUIAgent : public Communication::IAgent
{
public:
	GUIAgent();
	GUIAgent(int port, string ip, bool syncmode,double broadcastint,string key);
	virtual ~GUIAgent();
	int GetPort();
	string GetIP();
	bool GetSyncMode();
	bool GetSyncFlag();
	int GetIterationSync();
	string GetKey();
	double GetTimeStamp();
	double GetBroadcastInterval();
	void SetPort(int port);
	void SetIP(string ip);
	void SetKey(string key);
	void SetSyncMode(bool syncmode);
	void SetIterationSync(int value);
	void SetTimeStamp(double value);
	void SetBroadcastInterval(double value);
	void SetSyncFlag(bool value);
	string FilterData(string data);
	DataAgent* GetDataAgent();
private:
	int port;
	string ip;
	bool syncmode;
	bool syncflag;
	int iterationsync;
	string agentkey;
	IFilter *filter;
	double timestamp;
	double broadcastinterval;
};

}

#endif /*GUIAGENT_H_*/
